<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

$folder_name = "api/";
$intro_video_path = $folder_name . "intro.mp4";
$message = "";

if (isset($_POST["images"])) {
    $errors = array();
    $file_name = $_FILES["image"]["name"];
    $file_size = $_FILES["image"]["size"];
    $file_tmp = $_FILES["image"]["tmp_name"];
    $file_type = $_FILES["image"]["type"];
    $file_name_parts = explode(".", $_FILES["image"]["name"]);
    $file_ext = strtolower(end($file_name_parts));
    $extensions = array("mp4");
    
    if (!in_array($file_ext, $extensions)) {
        $errors[] = "Extension not allowed, please choose an MP4 file.";
    }

    if ($file_size > 11242880) {
        $errors[] = "File size must not exceed 5 MB";
    }

    if (empty($errors)) {
        move_uploaded_file($file_tmp, $folder_name . "intro.mp4");
        header("Location: " . $_SERVER["PHP_SELF"]);
        exit;
    } else {
        foreach ($errors as $error) {
            $message .= "<div class=\"alert alert-danger\">$error</div>";
        }
    }
}

include("includes/header.php");
?>

<!-- Begin Page Content -->
<div class="container-fluid">
    <div class="col-md-8 mx-auto">
        <!-- ... (your existing HTML code) ... -->

        <!-- Custom codes -->
        <div class="card-body">
            <div class="form-group">
                <form method="post" enctype="multipart/form-data">
                    <label class="control-label" for="intro">
                        <strong> Upload Intro Video File</strong>
                    </label>
                    <div class="input-group">
                        <div class="custom-file">
                            <input type="file" class="custom-file-input" name="image" id="intro" placeholder="Choose Intro" onchange="uploadintro(this)" aria-describedby="intro">
                            <label class="custom-file-label" for="intro" placeholder="Choose Intro"><span id="image-intro"></span></label>
                            <input type="hidden" name="image" value="intro">
                        </div>
                        <button type="submit" name="images" class="btn btn-info">Upload</button>
                    </div>
                </form>
                <br>
            </div>
        </div>

        <!-- Theme -->
        <div class="align-items-center">
            <center>
                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Current Intro</div>
                <div class="h5 mb-0 font-weight-bold text-gray-800">
                    <video width="500" autoplay="true" muted preload="auto" controls>
                        <source src="<?= $intro_video_path . "?t=" . time() ?>" type="video/mp4">
                    </video>
                </div>
            </center>
        </div>
</div>
                <br><br>
                <br><br>
                <footer></footer>
            </div>
        </div>
    </div>
</div>

<?php
echo $message;
include('includes/footer.php');
?>
</body>
</html>

